/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.potion;

import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SmokeAbstinenceEffect
extends MobEffect {
    public SmokeAbstinenceEffect() {
        super(MobEffectCategory.BENEFICIAL, -6710887);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        Player player;
        super.m_6742_(pLivingEntity, pAmplifier);
        if (pLivingEntity.m_9236_().m_5776_()) {
            return;
        }
        if (pLivingEntity instanceof Player && (player = (Player)pLivingEntity) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_8951_().m_6085_((Player)serverPlayer, Stats.f_12988_.m_12902_((Object)Stats.f_12992_), 0);
        }
        if (pLivingEntity.m_9236_().m_46472_() == Level.f_46429_) {
            SmokeAbstinenceEffect.addEffects(pLivingEntity, pAmplifier);
        }
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return pDuration % 100 == 0;
    }

    static void addEffects(LivingEntity entity, int pAmplifier) {
        boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, isPowerful ? pAmplifier * 2 + 1 : pAmplifier + 1));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 300));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 300, isPowerful ? pAmplifier * 3 + 2 : pAmplifier + 2));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 300, pAmplifier));
    }

    @Mod.EventBusSubscriber(modid="immortalers_delight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class SmokeAbstinenceEffectEvent {
        @SubscribeEvent
        public static void onCreatureHurt(LivingHurtEvent evt) {
            if (evt.isCanceled() || evt.getSource().m_269533_(DamageTypeTags.f_268630_)) {
                return;
            }
            LivingEntity hurtOne = evt.getEntity();
            if (!hurtOne.m_9236_().f_46443_) {
                float damage = evt.getAmount();
                MobEffectInstance effect = hurtOne.m_21124_((MobEffect)ImmortalersDelightMobEffect.SMOKE_ABSTINENCE.get());
                if (effect != null) {
                    boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
                    int lv = effect.m_19564_();
                    MobEffectInstance effect2 = hurtOne.m_21124_(MobEffects.f_19606_);
                    if (effect2 != null) {
                        lv -= effect2.m_19564_();
                    }
                    if (lv >= 0) {
                        float buffer = 1.0f;
                        for (int i = 0; i <= (isPowerful ? lv * 2 + 1 : lv + 1); ++i) {
                            buffer *= 0.8f;
                        }
                        evt.setAmount(Math.min(damage * buffer, damage));
                    }
                }
            }
        }
    }
}

